/*
 * MosP - Mind Open Source Project         http://www.mosp.jp/
 * Copyright (C) 1987-2009 MIND Co., Ltd.  http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.kintai.action;

import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import java.util.List;

import jp.mosp.common.CommonConst;
import jp.mosp.common.action.AttendanceTotalAction;
import jp.mosp.common.common.MospConst;
import jp.mosp.common.common.MospException;
import jp.mosp.common.common.MospUtility;
import jp.mosp.common.part.KintaiCommonPart;

import jp.mosp.kintai.dto.MScheduleDto;
import jp.mosp.kintai.vo.ScheduleConfirmListVo;

public class ScheduleConfirmListAction extends AttendanceTotalAction {

	// R}h
	private static final String CMD_CONFIRM_LIST_SHOW			= "K1230";
	public  static final String CMD_CONFIRM_LIST_SEARCH		= "K1232";

	/**
	 * RXgN^
	 */
	public ScheduleConfirmListAction() {
		super();
	}

	/**
	 * ANV
	 */
	public void action() throws Exception {
		// VO̎擾
		ScheduleConfirmListVo vo;
		vo = (ScheduleConfirmListVo)getStoredVo(CommonConst.VO_SCHEDULE_CONFIRM_LIST);
		if (vo == null) {
			vo = new ScheduleConfirmListVo();
		}
		vo.initVo(cfg, msg, cmd, aspUser, user);
		vo.clearMessage();
		vo.clearErrField();
		storeVo(CommonConst.VO_SCHEDULE_CONFIRM_LIST, vo);
		// VOyуtH[hURL̐ݒ
		setVo(vo);
		setUrl(vo.getRetUrl());
		// DBRlNV擾
		getConnection();
		// [U[擾
		getInfo(user.getUserId());
		// \
		Date current = util.getSystemDate();
		// v_E擾
		vo.aryPltYear  = util.getYearArray(MospUtility.getYear (current), 2, 1);
		vo.aryPltMonth = util.getMonthArray();
		// ΏێЈݒ
		vo.setSelectKCode(mKihon.getKCode());
		// R}h̏
		if (cmd.equals(CMD_CONFIRM_LIST_SHOW)) {
			// \
			// Ώ۔Nݒ
			vo.setPltYear(String.valueOf(MospUtility.getYear(current)));
			vo.setPltMonth(String.valueOf(MospUtility.getMonth(current)));
			// 
			searchScheduleList(vo);	
		} else if (cmd.equals(CMD_CONFIRM_LIST_SEARCH)) {
			// Ώ۔Nݒ
			vo.setParams(request);
			// 
			searchScheduleList(vo);
		} else {
			throw new MospException(MospConst.EX_CMD_INVALID);
		}
	}

	/**
	 * \ꗗ
	 * @param vo VoCX^X
	 * @throws Exception
	 */
	private void searchScheduleList(
			ScheduleConfirmListVo vo
	) throws Exception {
		// DBRlNV擾
		if (conn == null) {
			getConnection();
		}
		// ΑӃf[^擾
		//getScheduleList(vo.getSelectKCode(), vo.getPltYear(), vo.getPltMonth());
		/*						
		 *  	2009/01/20	m.yoshida	ߓΉ
		 */
		//getScheduleList(vo.getSelectKCode(), utility.getYearMonth(vo.getPltYear(), vo.getPltMonth()));
		getScheduleListForView(vo.getSelectKCode(), util.getYearMonth(vo.getPltYear(), vo.getPltMonth()));
		// Wvf[^Ԑݒ
		setScheduleHours(scheduleList);
		// Wvf[^z쐬
		makeScheduleArray(scheduleList);
		// Wv
		totalScheduleDaily(scheduleList);
		// l{̎擾
		setSelectBasicInfo(vo);
		// Wvf[^ƃx𕪗
		String[] aryLabel 	= new String[aryAttendanceCompile.length];
		String[] aryCompile = new String[aryAttendanceCompile.length];
		for (int i = 0; i < aryAttendanceCompile.length; i++) {
			aryLabel[i] = aryAttendanceCompile[i][0];
			aryCompile[i] = aryAttendanceCompile[i][1];
		}
		// VOݒ
		vo.setFields(aryAttendance, aryCompile, aryLabel);
	}

	/**
	 * Wvf[^z쐬
	 * @throws Exception
	 */
	private void makeScheduleArray(List<MScheduleDto> scheduleList) throws Exception {
		// DBRlNV擾
		if (conn == null) {
			getConnection();
		}
		// f[^擾
		Calendar cal = Calendar.getInstance();
		cal.setTime(MospUtility.getDate(startDate));
		int count = 0;
		while (MospUtility.getDate(endDate).compareTo(cal.getTime()) >= 0) {
			cal.add(Calendar.DAY_OF_MONTH, 1);
			count++;
		}
		// z񏉊
		aryAttendance = new String[count][40];
		for (int i = 0; i < aryAttendance.length; i++) {
			for (int j = 0; j < aryAttendance[i].length; j++) {
				aryAttendance[i][j] = "";
			}
		}
		// tݒ
		cal.setTime(MospUtility.getDate(startDate));
		for (int i = 0; i < aryAttendance.length; i++) {
			// t
			aryAttendance[i][0] = String.valueOf(MospUtility.getMonth(cal.getTime()))
			+ CommonConst.SEPARATOR_DATE
			+ String.valueOf(cal.get(Calendar.DAY_OF_MONTH));
			// j
			aryAttendance[i][1] = getDayOfWeek(cal.get(Calendar.DAY_OF_WEEK));
			// lijՓAxj
			StringBuffer remark = new StringBuffer();
			String holidayName = getPublicHolidayName(cal.getTime());
			if (holidayName.length() != 0) {
				remark.append(holidayName);
				remark.append(CommonConst.NAM_COMMON_HALF_KANA_SPACE);
			}
			aryAttendance[i][7] = remark.toString();
			cal.add(Calendar.DAY_OF_MONTH, 1);
		}
		// f[^̐ݒ
		Iterator<MScheduleDto> it = scheduleList.iterator();
		while (it.hasNext()) {
			cal.setTime(MospUtility.getDate(startDate));
			MScheduleDto dto = it.next();
			Date scheduleDate = MospUtility.getDate(dto.getHizuke());
			for (int i = 0; i < aryAttendance.length; i++) {
				if (scheduleDate.compareTo(cal.getTime()) == 0) {
					// Ζ`
					String kinmu = "";
					if (KintaiCommonPart.isAvailableWorkType(dto)) {
						kinmu = getWorkTypeInfo(dto.getKinmu()).getShiftName();
						// oΎ
						aryAttendance[i][3] = dto.getSyJikoku();
						// ދΎ
						aryAttendance[i][4] = dto.getTaJikoku();
						// Ζ
						aryAttendance[i][5] = getHourString(util.convIntegerTimeToDoubleTime(dto.getKinmuJi()));
						// xe
						aryAttendance[i][6] = getHourString(util.convIntegerTimeToDoubleTime(dto.getKyukeiJi()));
					} else if (KintaiCommonPart.isWeekHoliday(dto)) {
						// Tx̏ꍇ
						kinmu = CommonConst.ATTENDANCE_TYPE_WEEK_HOLIDAY;
					} else {
						for (int k = 0; k < aryHolidayReason.length; k++) {
							if (aryHolidayReason[k][0].equals(dto.getKKRiyuu())) {
								kinmu = aryHolidayReason[k][1];
							}
						}
					}
					aryAttendance[i][2] = kinmu;
					// x
					if (KintaiCommonPart.isStartHalfHoliday(dto)) {
						aryAttendance[i][7] += CommonConst.NAM_SHORT_START_ATTENDANCE + CommonConst.NAM_VACATION_LEAVE_HALF;
						aryAttendance[i][7] += CommonConst.NAM_COMMON_HALF_KANA_SPACE;
					}
					if (KintaiCommonPart.isQuitHalfHoliday(dto)) {
						aryAttendance[i][7] += CommonConst.NAM_SHORT_QUIT_ATTENDANCE + CommonConst.NAM_VACATION_LEAVE_HALF;
						aryAttendance[i][7] += CommonConst.NAM_COMMON_HALF_KANA_SPACE;						
					}
					if (KintaiCommonPart.isWorkOnHoliday(dto)) {
						aryAttendance[i][7] += CommonConst.NAM_WORK_ON_HOLIDAY;
						aryAttendance[i][7] += CommonConst.NAM_COMMON_HALF_KANA_SPACE;						
					}
					break;
				}
				cal.add(Calendar.DAY_OF_MONTH, 1);
			}
		}
	}

	/**
	 * Wv
	 * @throws Exception 
	 */
	private void totalScheduleDaily(List<MScheduleDto> scheduleList) throws Exception {
		// DBRlNV擾
		if (conn == null) {
			getConnection();
		}
		// f[^擾
		Calendar cal = Calendar.getInstance();
		cal.setTime(MospUtility.getDate(startDate));
		int count = 0;
		while (MospUtility.getDate(endDate).compareTo(cal.getTime()) >= 0) {
			cal.add(Calendar.DAY_OF_MONTH, 1);
			count++;
		}
		// z̏
		aryAttendanceCompile = new String[18][2];
		// ϐ錾Aϐ̏
		// ΖԌv
		int totalWork = 0;
		// xeԌv
		int totalInterbal = 0;
		// oΓv
		int totalWorkDays = 0;
		// Lxv
		double totalPaidHoliday = 0;
		// ʋxɌv
		int totalParticularHoliday = 0;
		// Γv
		int totalAbsence = 0;
		// axɌv
		int totalMedicalLeave = 0;
		// xv
		int totalCompensationDay =0;
		// U֋xɌv
		int totalTransfer = 0;
		// xɌv
		int totalOther = 0;
		// Wvf[^擾
		Iterator<MScheduleDto> it = scheduleList.iterator();
		// WvJn
		while (it.hasNext()) {
			cal.setTime(MospUtility.getDate(startDate));
			MScheduleDto dto = it.next();
			Date scheduleDate = MospUtility.getDate(dto.getHizuke());
			for (int i = 0; i < count; i++) {
				if (scheduleDate.compareTo(cal.getTime()) == 0) {
					// ΑӍ
					if (KintaiCommonPart.isAvailableWorkType(dto)) {
						// Ζ
						totalWork += dto.getKinmuJi();
						// xe
						totalInterbal += dto.getKyukeiJi();
						// oΓ
						if (dto.getKinmuJi() > 0) {
							totalWorkDays++;
						}
						// x
						if (KintaiCommonPart.isStartHalfHoliday(dto) || KintaiCommonPart.isQuitHalfHoliday(dto)) {
							totalPaidHoliday += 0.5;
						}
					} else {
						// xɍ
						if (!dto.getKKRiyuu().equals("")) {
							if (dto.getKKRiyuu().equals("0")) {
								// LxɁim_code, xɗR, tcode="0"j
								totalPaidHoliday++;
							} else if (dto.getKKRiyuu().equals("1")) {
								// ʋxɁim_code, xɗR, tcode="1"j
								totalParticularHoliday++;
							} else if (dto.getKKRiyuu().equals("2")) {
								// Γim_code, xɗR, tcode="2"j
								totalAbsence++;
							} else if (dto.getKKRiyuu().equals("3")) {
								// axɁim_code, xɗR, tcode="3"j
								totalMedicalLeave++;
							} else if (dto.getKKRiyuu().equals("4")) {
								// xim_code, xɗR, tcode="4"j
								totalCompensationDay++;
							} else if (dto.getKKRiyuu().equals("5")) {
								// U֋xɁim_code, xɗR, tcode="5"j
								totalTransfer++;
							} else {
								// xɁim_code, xɗR, tcode="6"j
								totalOther++;
							}
						}
					}
				}
				cal.add(Calendar.DAY_OF_MONTH, 1);
			}
		}
		// z
		// Ζԍv
		aryAttendanceCompile[0][0] = CommonConst.NAM_WORKING;
		aryAttendanceCompile[0][1] = getHourString(util.convIntegerTimeToDoubleTime(totalWork));
		// xeԍv
		aryAttendanceCompile[1][0] = CommonConst.NAM_INTERVAL_TIME;
		aryAttendanceCompile[1][1] = getHourString(util.convIntegerTimeToDoubleTime(totalInterbal));
		// oΓ
		aryAttendanceCompile[2][0] = CommonConst.NAM_PRESENCE;
		aryAttendanceCompile[2][1] = String.valueOf(totalWorkDays);
		// Lxɓ
		aryAttendanceCompile[3][0] = aryHolidayReason[0][1];
		aryAttendanceCompile[3][1] = String.valueOf(totalPaidHoliday);
		// ʋxɓ
		aryAttendanceCompile[4][0] = aryHolidayReason[1][1];
		aryAttendanceCompile[4][1] = String.valueOf(totalParticularHoliday);
		// ΋xɓ
		aryAttendanceCompile[5][0] = aryHolidayReason[2][1];
		aryAttendanceCompile[5][1] = String.valueOf(totalAbsence);
		// axɓ
		aryAttendanceCompile[6][0] = aryHolidayReason[3][1];
		aryAttendanceCompile[6][1] = String.valueOf(totalMedicalLeave);
		// x
		aryAttendanceCompile[7][0] = aryHolidayReason[4][1];
		aryAttendanceCompile[7][1] = String.valueOf(totalCompensationDay);
		// U֋xɓ
		aryAttendanceCompile[8][0] = aryHolidayReason[5][1];
		aryAttendanceCompile[8][1] = String.valueOf(totalTransfer);
		// xɓ
		aryAttendanceCompile[9][0] = CommonConst.NAM_OTHER_SHORT;
		aryAttendanceCompile[9][1] = String.valueOf(totalOther);
	}

}
